<?php // $Id: class.socket.php,v 1.1 2007/05/05 11:18:00 janne Exp $

/**
 * Connection_socket sub class
 *
 * This file contains an interface for socket functions
 * used in connection class.
 *
 * @package Connection
 * @author Janne Mikkonen
 * @version 1.0
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */

/**
 * Connection_socket sub class
 *
 * @package Connection
 * @author Janne Mikkonen
 * @author $Author: janne $
 * @version $Revision: 1.1 $
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
class Connection_socket extends Connection {

    var $domain   = AF_INET;
    var $type     = SOCK_STREAM;
    var $protocol = SOL_TCP;
    var $sock     = null;

    /**
     * PHP 4 constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    function Connection_socket($host, $port, $type) {
        if ( !function_exists('socket_create') ) {
            $this->error("Socket extension is not present!!!");
            return false;
        }
        parent::Setup($type);
        $this->_host = $host;
        $this->_port = $port;
    }

    /**
     * PHP 5 constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    function __construct ($host, $port, $type) {
        $this->Connection_socket($host, $port, $type);
    }

    /**
     * Set address/protocol family.
     *
     * Available address/protocol families:
     * AF_INET, AF_INET6 and AF_UNIX
     *
     * @param int $domain
     * @return void
     */
    function setDomain($domain) {
        if ( $domain & AF_UNIX ) {
            $this->domain = AF_UNIX;
        } else if ( $domain & AF_INET6 ) {
            $this->domain = AF_INET6;
        } else {
            $this->domain = AF_INET;
        }
    }

    /**
     * Set socket type
     *
     * @param int $type
     * @return void
     */
    function setType ($type) {
        switch ( intval($type) ) {
            case SOCK_DGRAM: $this->type = SOCK_DGRAM; break;
            case SOCK_SEQPACKET: $this->type = SOCK_SEQPACKET; break;
            case SOCK_RAW: $this->type = SOCK_RAW; break;
            case SOCK_RDM: $this->type = SOCK_RDM; break;
        }
    }

    /**
     * Create a socket
     *
     * @access private
     * @return mixed Returns a resource on success an false when failed
     */
    function _create () {
        $socket = @socket_create($this->domain, $this->type, $this->protocol);
        if ( is_resource($socket) ) {
            return $socket;
        }
        return false;
    }

    /**
     * Bind connection to address
     *
     * @access private
     * @param string $address
     * @param int $port
     * @return bool
     */
    function _bind ($address, $port=null) {
        if ( $this->sock ) {
            if ( !is_null($port) ) {
                return @socket_bind($this->sock, $address, $port);
            }
            return @socket_bind($this->sock, $address);
        }
        return false;
    }

    /**
     * Listen requested resource.
     *
     * @access private
     * @param int $backlog
     */
    function _listen($backlog=5) {
        if ( $this->sock &&
           ($this->type === SOCK_STREAM or $this->type === SOCK_SEQPACKET) ) {
            return @socket_listen($this->sock, $backlog);
        }
    }

    /**
     * Open connection
     *
     * Opens a connection to required host
     * @return mixed
     */
    function Open () {
        $this->sock = $this->_create();
        if ( $this->sock < 0 ) {
            $this->_errnro = socket_last_error();
            $this->_errstr = socket_strerror($this->_errnro);
            $this->error("Socket create failed: {$this->_errstr}");
        }

        if ( !@socket_connect($this->sock, $this->_host, $this->_port) ) {
            $this->_errnro = socket_last_error();
            $this->_errstr = socket_strerror($this->_errnro);

            $this->error("Could not connect to {$this->_host}: {$this->_errstr}");
        }
        return true;
    }

    /**
     * Close connection.
     * @return void
     */
    function Close () {
        if ( is_resource($this->sock) ) {
            socket_close($this->sock);
            return true;
        }
        return false;
    }

    /**
     * Write data
     *
     * Send data to server.
     * @param string $data Data to send
     * @return bool
     */
    function Write ($data) {
        if ( is_resource($this->sock) ) {
            return socket_write($this->sock, $data, strlen($data));
        }
        return false;
    }

    /**
     * Read data from connection
     *
     * @param $length
     * @return string
     */
    function Read ($length=512, $type=PHP_BINARY_READ) {
        if ( is_resource($this->sock) ) {
            $out = '';
            while ( $buf = socket_read($this->sock, $length, $type) ) {
                $out .= $buf;
            }
            return $out;
        }
    }

    /**
     * Override parent method
     *
     * @see Connection::setSecure()
     */
    function setSecure () {
        return;
    }

}
?>