<?php // $Id: class.fsockopen.php,v 1.1 2007/05/05 11:18:00 janne Exp $
    error_reporting(E_ALL);
/**
 * Connection_fsockopen sub class
 *
 * This file contains an interface for fsockopen functions
 * used in connection class.
 *
 * @package Connection
 * @author Janne Mikkonen
 * @version 1.0
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */

/**
 * Connection_fsockopen sub class
 *
 * @package Connection
 * @author Janne Mikkonen
 * @author $Author: janne $
 * @version $Revision: 1.1 $
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
class Connection_fsockopen extends Connection {

    /**
     * @var resource
     */
    var $sh  = null;

    /**
     * PHP 4 constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    function Connection_fsockopen($host, $port, $type) {
        parent::Setup($type);
        $this->_host = $host;
        $this->_port = $port;
    }

    /**
     * PHP 5 constructor.
     *
     * @param string $host Hostname or IP-address
     * @param int $port Port number
     * @param string $type interface name
     */
    function __construct ($host, $port, $type) {
        $this->Connection_fsockopen($host, $port, $type);
    }

    /**
     * Open connection
     *
     * Opens a connection to required host
     * @return mixed
     */
    function Open () {
        $prefix = ( $this->_proto != 'tcp') ? $this->_proto  .'://' :
                  (!empty($this->_secure)   ? $this->_secure .'://' : '');
        $strhost = $prefix . $this->_host;

        $this->sh = @fsockopen($strhost, $this->_port,
                               $this->_errnro, $this->_errstr,
                               $this->_timeout);
        if ( !$this->sh ) {
            $error  = $this->_errnro ." ";
            $error .= $this->_errstr;
            $this->error($error . ' '. $strhost, E_USER_ERROR);
        }

        return true;
    }

    /**
     * Close connection.
     * @return void
     */
    function Close () {
        if ( $this->sh ) {
            fclose($this->sh);
            $this->sh  = null;
            $this->eof = false;
            return true;
        }
    }

    /**
     * Write data
     *
     * Send data to server.
     * @param string $data Data to send
     * @param int $length Length of data
     * @return bool
     */
    function Write ($data, $length=null) {
        if ( $this->sh ) {
            if ( !is_null($length) && is_integer($length) ) {
                return fwrite($this->sh, $data, $length);
            } else {
                return fwrite($this->sh, $data);
            }
        }
        return false;
    }

    /**
     * Read data from connection
     *
     * @param $length
     * @return string
     */
    function Read ($length=512) {
        if ( $this->sh ) {
            $out = '';
            while ( !feof($this->sh) ) {
                $out .= fread($this->sh, $length);
            }
            return $out;
        }
    }

}

?>