<?php // $Id: class.connection.php,v 1.1 2007/05/05 11:18:00 janne Exp $
    error_reporting(E_ALL);
/**
 * Connection class
 *
 * A simple class for creating connections between hosts.
 * This class hides the actual connection functions so
 * programmer doesn't have to care which socket functions
 * are used ( fsockopen or socket ).
 *
 * @package Connection
 * @author Janne Mikkonen
 * @version 1.0
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */

    //error_reporting(E_ALL);
    define('CONN_CLASS_DIR', dirname(realpath(__FILE__)));

/**
 * Connection base class
 *
 * Setup basic properties and load requested connector, which
 * can be fsockopen or socket.
 *
 * @package Connection
 * @author Janne Mikkonen
 * @author $Author: janne $
 * @version $Revision: 1.1 $
 * @date $Date: 2007/05/05 11:18:00 $
 * @copyright 2007 - Janne Mikkonen <janne dot mikkonen at julmajanne dot com>
 * @copyright 2007 - Mediamaisteri Group
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
class Connection {

    /**
     * To hold information which socket funcitos to use.
     * @var string Socket-functions name
     */
    var $_socket = null;

    /**
     * Timeout for the connection.
     * @var int
     */
    var $_timeout     = 30;

    /**
     * Host name or IP address to connect to.
     * @var string
     */
    var $_host        = null;

    /**
     * Protocol to use ( tcp, udp and with fsockopen ssl and tls ).
     * @var string
     */
    var $_proto       = 'tcp';

    /**
     * $var string
     */
    var $_secure      = '';
    /**
     * @var int
     */
    var $_port        = null;
    /**
     * @var string
     */
    var $_errstr      = null;
    /**
     * @var int
     */
    var $_errnro      = null;

    /**
     * Instantiate basic properties.
     *
     * @access private
     * @param string $socket String socket functions to use.
     * @return void
     */
    function Setup ( $_socket=null ) {

        $this->_socket = !empty($_socket) ?
                            $this->CleanName($_socket) :
                            $this->_socket;

    }

    /**
     * Initialize class
     *
     * @param string $host
     * @param int $port
     * @param string $_socket Socket interface to load.
     * @return object
     */
    function Init ( $host, $port, $_socket='fsockopen' ) {
        static $class;

        if ( !empty($this) ) {
            if ( is_subclass_of($this, 'Connection') ) {
                trigger_error("Method \"Init\" cannot be called from sub class!",
                          E_USER_ERROR);
            }
        }

        if ( !$host = Connection::CheckHost($host) ) {
            trigger_error("Something wrong with the hostname!!!", E_USER_ERROR);
        }

        $port = intval($port);

        $classdir  = CONN_CLASS_DIR .'/connectors';
        $classfile = !empty($_socket) ?
                        Connection::CleanName($_socket) : null;
        $classname = 'Connection_'. $classfile;

        if ( !is_null($classname) ) {
            include_once($classdir .'/class.'. $classfile .'.php');
            // Making curl to load each and every time makes it
            // a bit slow, but until workaround been discovered
            // it'll be this way...
            if ( is_object($class) && $_socket != 'curl' ) {
                return $class;
            } else {
                $class = new $classname($host, $port, $_socket);
                return $class;
            }
        }

    }

    /**
     * Clean unwanted characters from socket name
     *
     * @param string $name
     * @return string
     */
    function CleanName ($name) {
        if ( !$name = Connection::CheckName($name) ) {
            trigger_error("Something wrong with the socket name!",
                          E_USER_ERROR);
        }
        return $name;
    }

    /**
     * Check given socket interface name
     *
     * @param string $name
     * @return string
     */
    function CheckName ($name) {
        $tmp = preg_replace("/[^a-zA-Z]/", "", $name);
        if ( strcmp($name, $tmp) !== 0 ) {
            return false;
        }
        return $tmp;
    }

    /**
     * Check given hostname.
     *
     * @param string $name Hostname or IP-address
     * @return mixed
     */
    function CheckHost ($name) {
        $name = trim($name);
        $ipv4pattern = "/^([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})$/";
        if ( preg_match($ipv4pattern, $name) ) {
            return $name;
        }
        if ( preg_match("/^([a-zA-Z0-9_\-\.]+)$/", $name) ) {
            return preg_replace("/[^a-zA-Z0-9_\-\.]/", "", $name);
        }
        return false;
    }

    /**
     * Set timeout for the connection.
     *
     * @param int $timeout
     */
    function setTimeOut ($timeout) {
        $timeout = intval($timeout);
        if ( $timeout > 0 ) {
            $this->_timeout = $timeout;
        }
    }

    /**
     * Apply secure protocol if requested.
     *
     * Notice. Only fsockopen and Curl can use secure connections.
     *
     * @param string $type Either ssl or tls
     * @void
     */
    function setSecure($type='ssl') {
        $type = preg_replace("/\s+/", "", $type);
        $type = trim($type);

        if ( preg_match("/^(ssl|tls)$/", $type) ) {
            $this->_secure = $type;
        }
    }

    /**
     * Simple error message page
     *
     * @param string $message
     * @return void
     */
    function error ($message=null) {

        echo '<div id="error" class="error">';
        if ( !empty($message) ) {
            echo '<div id="errmsg" class="msg">';
            echo htmlspecialchars($message);
            echo '</div>'."\n";
        }
        echo '<div id="errors">';
        echo 'Error string: '. $this->_errstr .'<br />';
        echo 'Error number: '. $this->_errnro .'</div>'."\n";
        exit;
    }

}

?>