<?php // $Id: kannel.class.php,v 1.5 2007/05/28 06:37:24 janne Exp $
/**
 * This page holds SMSKannel sub class.
 * @package SMS
 * @subpackage SMSKannel
 */

/**
* Kannel subclass
*
* @package SMS
* @subpackage SMSKannel
* @author Janne Mikkonen
* @version $Revision: 1.5 $
* @copyright 2005 - 2007 Janne Mikkonen
* @copyright 2005 - 2007 Mediamaisteri Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/
class SMSKannel extends SMS {

    /**
    * Kannel gateway phone number variable name.
    * Defines where this message is sended to.
    * @var string
    */
    var $varto   = 'to';

    /**
    * Kannel gateway Sender variable name.
    * @var string
    */
    var $varfrom = 'from';

    /**
    * Kannel gateway text variable name.
    * @var string
    */
    var $vartext = 'text';

    /**
    * Kannel gateway UDH variable name.
    * @var string
    */
    var $varudh  = 'udh';

    /**
    * Scriptpath for Kannel gateway webinterface.
    * @var string
    */
    var $scriptpath  = '/cgi-bin/sendsms';

    /**
     * Delimiter for multiple recipients
     * @var string
     */
    var $recipientdelim = " ";

    /**
    * Constructor function
    * @param object $CNF Config values as an object.
    */
    function SMSKannel (&$config) {
        parent::initialize($config);
    }

    function __construct(&$config) {
        $this->SMSKannel($config);
    }

    function set_script_path ($path) {

        $path = clean_param($path, PARAM_LOCALURL);
        $this->scriptpath = $path;

    }

    /**
    * Send SMS message through Kannel gateway web interface.
    *
    * @param mixed $to Receivers mobilephone number or array of numbers.
    * @param string $text SMS message to send.
    * @param string $from Senders mobilephone number.
    * @return mixed Returns false on failure and HTTP response on success.
    */
    function send_message ($to, $text, $from=NULL) {

        // Check message length
        // Max message length should be checked elsewhere
        //if (strlen($text) > 460) {
        //    return false;
        //}

        // Check if recipient address is an array meaning
        // there are multiple recipients for this message.
        if ( is_array($to) && $this->recipientdelim !== false ) {
            $tmp = '';
            for ( $i = 0; $i < sizeof($to); $i++ ) {
                if ( $i > 0 ) {
                    $tmp .= $this->recipientdelim;
                }
                $tmp .= $this->clean_number($to[$i]);
            }
            $to = $tmp;
        } else {
            $to = $this->clean_number($to);
        }

        $data = new stdClass;
        $data->to   = $to;
        $data->text = $text;
        $data->form = $from;
        $data->account = $this->clientid;

        // Kannel have username and password variables and it doesn't use
        // basic authentication method so, we'll need to add these values
        // into query string.
        $data->username = !empty($this->gwuser) ? $this->gwuser : '';
        $data->password = !empty($this->gwpass) ? $this->gwpass : '';

        if (! empty($auth) ) {
            $data->auth = $auth;
        }

        $command = $this->__build_http_cmd ($data);

        if ($result = $this->__exec($command)) {
            return $this->parse_http_response($result);
        } else {
            return false;
        }

    }

    /**
    * Not implemented.
    *
    * Kannel cannot send mms messages directly. You'll
    * need Mbuni for that (www.mbuni.org).
    *
    * @param string $to Receivers mobilephone number.
    * @param string $text Message to send along with data.
    * @param array $data Data to send as an array.
    * @return mixed
    */
    function send_mms_message () {
        parent::send_mms_message(NULL, NULL);
    }

    /**
     * Build request string fro HTTP GET method.
     *
     * @param object $data
     * @return string
     */
    function __build_http_cmd ($data) {

        $to       = '';
        $from     = '';
        $text     = '';
        $username = '';
        $password = '';

        if ( !empty($data->username) ) {
            $username = $data->username;
        }

        if ( !empty($data->password) ) {
            $password = $data->password;
        }

        if ( !empty($data->to) ) {
            $to = urlencode($data->to);
        }

        if ( !empty($data->from) ) {
            $from = rawurlencode($data->from);
        }

        if ( !empty($data->text) ) {
            $text = rawurlencode(utf8_encode($data->text));
        }

        $account = !empty($data->account) ? $data->account : $this->clientid;

        $command = sprintf("%s?%s=%s&%s=%s&%s=%s&%s=%s&%s=%s&%s=%s",
                           $this->scriptpath,
                           'username',
                           $username,
                           'password',
                           $password,
                           $this->varto,
                           $to,
                           $this->vartext,
                           $text,
                           'charset',
                           'UTF-8',
                           'account',
                           $account);

        if (! empty($from) ) {
            $command .= sprintf("&%s=%s",
                                $this->varfrom,
                                $from);
        }

        switch ($this->socket) {
            case 'socket':
            case 'fsockopen':
                // Generate HTTP 1.1 Request string.
                $command  = sprintf("GET %s HTTP/1.1\r\nHost: %s:%d\r\n",
                                    $command, $this->gwhost, $this->gwport);
                $command .= sprintf("User-Agent: %s\r\n", $this->useragent);
                $command .= sprintf("Connection: %s\r\n", 'close');
                $command .= "\r\n"; // Terminate request with empty line.
            break;
            case 'curl':
            break;
        }

        return $command;

    }

}
?>