<?php // $Id: userdiarydelete.php,v 1.4 2008/03/26 11:04:07 janne Exp $

    // BIG TODO:
    // Child pages are not deleted when parent page is deleted
    // Something wrong with the recursive method in Diary class.
    // FIX IT...

    require_once("../../config.php");
    require_once("lib.php");

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM);
    $pageid  = required_param('pageid',  PARAM_INT);

    if (! confirm_sesskey($skey) ) {
        error("Invalid session identifier!!!");
    }

    if ( (!$diary->isstudent) or ($diary->isteacher or $diary->isguest) ) {
        error("Only students can remove entries from user diary!!!",
              "$CFG->wwwroot/course/view.php?id={$diary->course->id}");
    }

    if ( !$chapter = get_record("learningdiary_pages", "id", $pageid) ) {
        error("Could not retreive requested chapter!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
    }

    if ( $data = data_submitted() ) {

        if ( !empty($data->cancel) ) {
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?".
                     "id={$diary->cm->id}&amp;pageid=$chapter->id");
        }

        if ( intval($data->pageid) !== intval($chapter->id) ||
             intval($USER->id) !== intval($chapter->userid) ) {
            error("You are not allowed to delete this chapter!!!");
        }

        // Get all possible childpages
        $userid = (int) $USER->id;
        $ldid   = (int) $diary->module->id;

        if ( $pages = get_records_select("learningdiary_pages",
                                         "userid = $userid AND learningdiaryid = $ldid",
                                         "",
                                         "id, parentid, title") ) {
            $kids = $diary->_get_pages_recursive($chapter->id, $pages, $userid);

            if ( !empty($kids) && is_array($kids) ) {
                $arrids = array();
                foreach ($kids as $key => $value) {
                    if ( $key != 0 ) {
                        $arrids[] = (int) $key;
                    }
                }
                array_push($arrids, $chapter->id);
                $strids = implode(",", $arrids);

                if ( delete_records_select("learningdiary_pages", "id IN ($strids) AND learningdiaryid = $ldid") ) {
                    // Delete corresponding values from history table.
                    delete_records_select("learningdiary_page_history",
                                               "pageid IN ($strids) AND learningdiaryid = $ldid");

                    add_to_log($diary->course->id, "learningdiary",
                               "Delete chapter", "view.php?id={$diary->cm->id}",
                               "{$diary->module->name}");
                    $strdeletesuccess = get_string('deletesuccess','learningdiary');
                    redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}",
                             $strdeletesuccess, 1);

                }
            } else {

                if ( delete_records("learningdiary_pages", "id", $chapter->id, "learningdiaryid", $ldid) ) {
                    add_to_log($diary->course->id, "learningdiary",
                               "Delete chapter", "view.php?id={$diary->cm->id}",
                               "{$diary->module->name}");

                    $strdeletesuccess = get_string('deletesuccess','learningdiary');
                    redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}",
                             $strdeletesuccess, 1);
                }
            }
        }

        error("Could not delete requested chapter!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");

    } else {

        if ( intval($USER->id) !== intval($chapter->userid) ) {
            error("You cannot delete chapter you do not own!",
                  "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        /// Print page.

        $strlearningdiaries = get_string("modulenameplural", "learningdiary");
        $strlearningdiary   = get_string("modulename", "learningdiary");
        $strdelete          = get_string('deletechapter', 'learningdiary', stripslashes($chapter->title));

        $strconfirm = get_string('confirmdeletechapter','learningdiary', stripslashes($chapter->title));

        $extlinks = array(array('name' => $strdelete, 'link' => '', 'type' => $strdelete));
        $navigation = build_navigation($extlinks, $diary->cm);
        print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                     $navigation, "", "", true,
                     update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                     navmenu($diary->course, $diary->cm));

        $diary->tabs();

        print_simple_box_start('center', '100%');
        print_heading($strdelete, 'center');

        print_simple_box_start('center', '60%', '', 5, 'noticebox', 'notice');
        ?>
        <form method="post" action="<?php echo basename(__FILE__) ?>">
        <input type="hidden" name="id"      value="<?php p($diary->cm->id) ?>" />
        <input type="hidden" name="sesskey" value="<?php p($USER->sesskey) ?>" />
        <input type="hidden" name="pageid"  value="<?php p($chapter->id) ?>" />
        <p style="text-align: center">
        <?php print($strconfirm); ?>
        </p>
        <p style="text-align: center">
        <input type="submit" value="<?php print_string('yes') ?>" />
        <input type="submit" name="cancel" value="<?php print_string('cancel') ?>" />
        </p>
        </form>
        <?php
        print_simple_box_end();

        print_simple_box_end();
        print_footer($diary->course);

    }