<?php // $Id: managementconfirm.php,v 1.3 2008/03/26 11:04:07 janne Exp $

// Confirm delete operations of guided learning diary.

    require('../../config.php');
    require('lib.php');

    $diary = new modLearningdiary();
    $skey  = required_param('sesskey', PARAM_ALPHANUM);

    if ( !confirm_sesskey($skey) ) {
        error("Session key error!");
    }

    if ( $data = data_submitted() ) {

        if ( !empty($data->cancel) ) {
            redirect("management.php?id={$diary->cm->id}&amp;sesskey=$USER->sesskey");
            exit;
        }

        if ( !$diary->check_confirm_key($data->confirmkey) ) {
            error("Confirmation key error!!!");
        }

        if ( !empty($data->remove) ) {
            /*foreach ( $data->remove as $key => $value ) {
                $data->remove[$key] = intval($value);
            }*/
            $data->remove = clean_param($data->remove, PARAM_INT);

            $removeids = learningdiary_get_deletable_ids($data->remove);

            if ( !empty($removeids) && is_array($removeids) ) {

                $removeids = implode(",", $removeids);
                $deletablepages = get_records_select("learningdiary_pages",
                                                 "structureid IN ($removeids) ".
                                                 "AND learningdiaryid = ". $diary->module->id);

                if ( !delete_records_select("learningdiary_guided_structure","id IN ($removeids)") ) {
                    error("Could not delete requested chapters!",
                          "$CFG->wwwroot/mod/learningdiary/management.php?id=".
                          "{$diary->cm->id}&sesskey=$USER->sesskey");
                }
                // Delete related student entries.
                if ( !empty($deletablepages) ) {
                    $pageids = array();
                    foreach ( $deletablepages as $page ) {
                        $page->id = intval($page->id);
                        array_push($pageids, $page->id);
                    }
                    $pageids = implode(",", $pageids);
                    delete_records_select("learningdiary_pages", "id IN ($pageids) ".
                                          "AND learningdiaryid = ". $diary->module->id);
                    delete_records_select("learningdiary_page_history",
                                          "pageid IN ($pageids) AND learningdiaryid = ".
                                          $diary->module->id);
                }
            }
        }

        $strmessage = get_string("confirmdeletesuccess", "learningdiary");
        redirect("management.php?id={$diary->cm->id}&sesskey=$USER->sesskey", $strmessage, 2);

    } else {

        $confirmdata = required_param('confirm', PARAM_RAW);
        $confirmdata = unserialize(base64_decode($confirmdata));

        if ( empty($confirmdata) ) {
            error("Required data missing!!!",
                  $CFG->wwwroot ."/mod/learningdiary/management.php?id={$diary->cm->id}".
                  "&amp;sesskey=$USER->sesskey");
        }

        if ( !$diary->check_confirm_key($confirmdata['confirmkey']) ) {
            error("Confirmation key error!!!");
        }

        if ( !is_array($confirmdata['removeids']) ) {
            error("Wrong data type detected!!!",
                  $CFG->wwwroot ."/mod/learningdiary/management.php?id={$diary->cm->id}".
                  "&amp;sesskey=$USER->sesskey");
        }

        $removeids = $confirmdata['removeids'];
        foreach ( $removeids as $key => $value ) {
            $removeids[$key] = intval($value);
        }

        // Cache some strings
        $strmanagement = get_string('management','learningdiary');
        $strcreated    = get_string('created','learningdiary');

        $strlearningdiaries = get_string("modulenameplural", "learningdiary");
        $strlearningdiary   = get_string("modulename",       "learningdiary");
        $strconfirmdelete   = get_string("confirmdelete",    "learningdiary");
        $strconfirmwarning  = get_string("confirmwarning",   "learningdiary");

        $extlinks = array(
                        array('name' => $strmanagement,
                              'link' => sprintf('management.php?id=%d&amp;sesskey=%s',
                                                $diary->cm->id, $USER->sesskey),
                              'type' => 'activity'),
                        array('name' => $strconfirmdelete,
                              'link' => '',
                              'type' => $strconfirmdelete));

        $navigation = build_navigation($extlinks, $diary->cm);
        print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                     $navigation, "", "", true,
                     update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                     navmenu($diary->course, $diary->cm));

        $removeids = implode(",", $removeids);
        $chapters = get_records_select("learningdiary_guided_structure", "id IN ($removeids)");

        print_simple_box_start("center");
        print_heading($strconfirmdelete);

        print "\n";
        print '<div class="mod_ld_confirm_warning">';
        print $strconfirmwarning;
        print '</div>'."\n";

        print '<form method="post" action="managementconfirm.php">'."\n";
        print '<input type="hidden" name="id"      value="'. $diary->cm->id .'" />'."\n";
        print '<input type="hidden" name="sesskey" value="'. $USER->sesskey .'" />'."\n";
        print '<input type="hidden" name="confirmkey" value="'. $confirmdata['confirmkey'] .'" />'."\n";
        print '<ul>'."\n";
        foreach ( $chapters as $chapter ) {
            print '<li>'. s($chapter->title) .'</li>'."\n";
            print '<input type="hidden" name="remove[]" value="'. $chapter->id .'" />'."\n";
        }
        print '</ul>'."\n";
        print '<div style="text-align: center"><input type="submit" value="'. get_string("yes") .'" />'."\n";
        print ' <input type="submit" name="cancel" value="'. get_string("cancel") .'" /></div>'."\n";
        print '</form>'."\n";

        print_simple_box_end();
        print_footer($course);
    }

////////////////////////////////// HELPER FUNCTIONS //////////////////////////////////


function learningdiary_get_deletable_ids($arrayids) {

    $idstodelete = array();
    foreach ( $arrayids as $id ) {
        array_push($idstodelete, $id);
        $ids = learningdiary_get_sub_chapters($id);
        if ( !empty($ids) ) {
            foreach ( $ids as $i ) {
                array_push($idstodelete, $i);
            }
            $idstodelete = array_unique($idstodelete);
        }
    }

    return $idstodelete;
}

function learningdiary_get_sub_chapters($parent) {

    static $ids;
    if ( empty($ids) ) {
        $ids = array();
    }

    $chapters = get_records("learningdiary_guided_structure", "parentid", $parent);

    if ( !empty($chapters) ) {
        foreach ( $chapters as $chapter ) {
            array_push($ids, $chapter->id);
            learningdiary_get_sub_chapters($chapter->id);
        }
    }
    return $ids;
}
?>