<?php // $Id: backuplib.php,v 1.4 2006/11/17 15:54:33 janne Exp $


    //This php script contains all the stuff to backup
    //learningdiary mods

    //This is the "graphical" structure of the learningdiary mod:
    //
    //                           learningdiary
    //                            (CL,pk->id)
    //                                 |
    //         ---------------------------------------------------
    //         |                                                 |
    // learningdiary_pages                         learningdiary_guided_structure
    //(UL,pk->id, fk->learningdiaryid,----------------(UL,pk->id, fk->learningdiaryid,
    // nt->parentid, fk->structureid)      |           nt->parentid)
    //         |                           |
    // learningdiary_page_history          |
    // (UL,pk->id,fk->learningdiaryid,     |            learningdiary_comments
    //  fk->pageid)                        ---------(UL,pk->id,fk->learningdiaryid,
    //                                                  fk->pageid)
    //
    //
    //
    // Meaning: pk->primary key field of the table
    //          fk->foreign key to link with parent
    //          nt->nested field (recursive data)
    //          CL->course level info
    //          UL->user level info
    //
    // TODO: inner link fix.
    //-----------------------------------------------------------

    //This function executes all the backup procedure about this mod
    function learningdiary_backup_mods($bf,$preferences) {
        global $CFG;

        $status = true;

        ////Iterate over learningdiary table
        if ($diaries = get_records ("learningdiary","course", $preferences->backup_course,"id")) {
            foreach ($diaries as $diary) {
                if (backup_mod_selected($preferences,'learningdiary',$diary->id)) {
                    $status = learningdiary_backup_one_mod($bf,$preferences,$diary);
                }
            }
        }
        return $status;
    }

    function learningdiary_backup_one_mod($bf,$preferences,$diary) {

        global $CFG;

        if ( is_numeric($diary) ) {
            $diary = get_record('learningdiary','id',$diary);
        }
        $status = true;

        //Start mod
        fwrite ($bf,start_tag("MOD",3,true));
        //Print learningdiary data
        fwrite ($bf,full_tag("ID",4,false,$diary->id));
        fwrite ($bf,full_tag("MODTYPE",4,false,"learningdiary"));
        fwrite ($bf,full_tag("NAME",4,false, $diary->name));
        fwrite ($bf,full_tag("INTRO",4,false, $diary->intro));
        fwrite ($bf,full_tag("DIARYMODE",4,false, $diary->diarymode));
        fwrite ($bf,full_tag("NUMBERING",4,false, $diary->numbering));
        fwrite ($bf,full_tag("TIMECREATED",4,false, $diary->timecreated));
        fwrite ($bf,full_tag("TIMEMODIFIED",4,false,$diary->timemodified));

        //if we've selected to backup users info
        if (backup_userdata_selected($preferences,'learningdiary',$diary->id)) {
            $status = backup_learningdiary_pages($bf,$preferences,$diary);
            if ($status && $diary->diarymode != 'user') {
                $status = backup_learningdiary_structure($bf,$preferences,$diary->id);
            }
        }
        //End mod
        $status =fwrite ($bf,end_tag("MOD",3,true));

        return $status;
    }

    function backup_learningdiary_pages ($bf,$preferences,$diary) {

        global $CFG;
        $status = true;

        $pages = get_records("learningdiary_pages","learningdiaryid",$diary->id,"id");

        //If there are pages
        if ($pages) {
            //Write start tag
            $status =fwrite ($bf,start_tag("PAGES",5,true));
            //Iterate over each page
            foreach ($pages as $page) {
                //Start post
                $status =fwrite ($bf,start_tag("PAGE",6,true));
                //Print page contents
                fwrite ($bf,full_tag("ID",8,false,$page->id));
                fwrite ($bf,full_tag("PARENTID",7,false,$page->parentid));
                fwrite ($bf,full_tag("LEARNINGDIARYID",7,false,$diary->id));
                fwrite ($bf,full_tag("USERID",7,false,$page->userid));
                fwrite ($bf,full_tag("STRUCTUREID",7,false,$page->structureid));
                fwrite ($bf,full_tag("TITLE",7,false,$page->title));
                fwrite ($bf,full_tag("CONTENT",7,false,$page->content));
                fwrite ($bf,full_tag("HIDDEN",7,false,$page->hidden));
                fwrite ($bf,full_tag("CREATED",7,false,$page->created));
                fwrite ($bf,full_tag("FORMAT",7,false,$page->format));
                // Don't backup page history. Restore each page as
                // version 1.0. But get comments.
                if ( $diary->diarymode != 'user' ) {
                $status = backup_learningdiary_comments($bf,$preferences,$page->id);
                }
                //End page
                $status =fwrite ($bf,end_tag("PAGE",6,true));
            }
            //Write end tag
            $status =fwrite ($bf,end_tag("PAGES",5,true));
        }
        return $status;
    }

    function backup_learningdiary_structure($bf,$preferences,$diary) {

        global $CFG;
        $status = true;

        $structures = get_records("learningdiary_guided_structure", "learningdiaryid", $diary, "id");
        if ( !empty($structures) ) {
            $status = fwrite($bf,start_tag("STRUCTURES",6,true));
            foreach ( $structures as $structure ) {
                // Print start tag
                $status = fwrite ($bf,start_tag("STRUCTURE",7,true));
                fwrite ($bf,full_tag("ID",8,false,$structure->id));
                fwrite ($bf,full_tag("PARENTID",8,false,$structure->parentid));
                fwrite ($bf,full_tag("LEARNINGDIARYID",8,false,$structure->learningdiaryid));
                fwrite ($bf,full_tag("TITLE",8,false,$structure->title));
                fwrite ($bf,full_tag("INFORMATION",8,false,$structure->information));
                fwrite ($bf,full_tag("AVAILABLE",8,false,$structure->available));
                fwrite ($bf,full_tag("CREATED",8,false,$structure->created));
                fwrite ($bf,full_tag("FORMAT",8,false,$structure->format));
                // End structure
                $status = fwrite($bf,end_tag("STRUCTURE",7,true));
            }
            $status = fwrite($bf,end_tag("STRUCTURES",6,true));
        }
        return $status;
    }

    function backup_learningdiary_comments($bf,$preferences,$pageid) {

        global $CFG;
        $status = true;

        $comments = get_records("learningdiary_comments", "pageid", $pageid, "id");
        if ( !empty($comments) ) {
            $status = fwrite ($bf,start_tag("COMMENTS",8,true));
            foreach ( $comments as $comment ) {
                $status = fwrite($bf,start_tag("ENTRY",9,true));

                fwrite($bf,full_tag("ID",8,false,$comment->id));
                fwrite($bf,full_tag("LEARNINGDIARYID",10,false,$comment->learningdiaryid));
                fwrite($bf,full_tag("PAGEID",10,false,$comment->pageid));
                fwrite($bf,full_tag("USERID",10,false,$comment->userid));
                fwrite($bf,full_tag("TEACHERID",10,false,$comment->teacherid));
                fwrite($bf,full_tag("TITLE",10,false,$comment->title));
                fwrite($bf,full_tag("COMMENT",10,false,$comment->comment));
                fwrite($bf,full_tag("CREATED",10,false,$comment->created));
                fwrite($bf,full_tag("MODIFIED",10,false,$comment->modified));
                fwrite($bf,full_tag("FORMAT",10,false,$comment->format));

                $status = fwrite($bf,end_tag("ENTRY",9,true));
            }
            $status = fwrite ($bf,end_tag("COMMENTS",8,true));
        }
        return $status;
    }

    ////Return an array of info (name,value)
   function learningdiary_check_backup_mods($course,$user_data=false,$backup_unique_code) {
        //First the course data
        $info[0][0] = get_string("modulenameplural","learningdiary");
        if ($ids = learningdiary_ids ($course)) {
            $info[0][1] = count($ids);
        } else {
            $info[0][1] = 0;
        }

        //Now, if requested, the user_data
        if ($user_data) {
            // pages
            $info[1][0] = get_string("chapters","learningdiary");
            if ($ids = learningdiary_page_ids_by_course ($course)) {
                $info[1][1] = count($ids);
            } else {
                $info[1][1] = 0;
            }
            // structures
            $info[2][0] = get_string("structures","learningdiary");
            if ($ids = learningdiary_structure_ids_by_course ($course)) {
                $info[2][1] = count($ids);
            } else {
                $info[2][1] = 0;
            }
            //Comments
            $info[3][0] = get_string("comments","learningdiary");
            if ($ids = learningdiary_comment_ids_by_course ($course)) {
                $info[3][1] = count($ids);
            } else {
                $info[3][1] = 0;
            }
        }
        return $info;
    }

    // INTERNAL FUNCTIONS. BASED IN THE MOD STRUCTURE

    //Returns an array of learningdiary id
    function learningdiary_ids ($course) {
        global $CFG;
        return get_records_sql ("SELECT a.id, a.course
                                 FROM {$CFG->prefix}learningdiary a
                                 WHERE a.course = '$course'");
    }

    function learningdiary_page_ids_by_course ($course) {
        global $CFG;
        return get_records_sql("SELECT p.id,p.learningdiaryid
                                FROM {$CFG->prefix}learningdiary_pages p,
                                     {$CFG->prefix}learningdiary a
                                WHERE a.course = '$course'
                                AND p.learningdiaryid = a.id");
    }

    function learningdiary_structure_ids_by_course($course) {
        global $CFG;
        return get_records_sql("SELECT s.id,s.learningdiaryid
                                FROM {$CFG->prefix}learningdiary_guided_structure s,
                                     {$CFG->prefix}learningdiary a
                                WHERE a.course = '$course'
                                AND s.learningdiaryid = a.id");
    }

    function learningdiary_comment_ids_by_course ($course ) {
        global $CFG;
        return get_records_sql("SELECT c.id,c.learningdiaryid
                                FROM {$CFG->prefix}learningdiary_comments c,
                                     {$CFG->prefix}learningdiary a
                                WHERE a.course = '$course'
                                AND c.learningdiaryid = a.id");
    }

?>