<?php // $Id: mod_form.php,v 1.1.2.1 2008/03/26 11:47:51 janne Exp $

    /**
     * This file contains necessary form definition for Learningdiary module
     *
     */

    require_once ($CFG->dirroot.'/course/moodleform_mod.php');

class mod_learningdiary_mod_form extends moodleform_mod {

    function definition() {

        global $CFG;
        $mform    =& $this->_form;

        // Form definition.
        $mform->addElement('header', 'general', get_string('general', 'form'));

        $mform->addElement('text', 'name', get_string('title', 'learningdiary'), array('size'=>'64'));
        $mform->setType('name', PARAM_TEXT);
        $mform->addRule('name', null, 'required', null, 'client');

        $mform->addElement('htmleditor', 'intro', get_string('intro', 'learningdiary'));
        $mform->setType('intro', PARAM_RAW);
        $mform->setHelpButton('intro', array('writing', 'questions', 'richtext'), false, 'editorhelpbutton');
        $mform->addRule('intro', get_string('required'), 'required', null, 'client');

        $opmodes = array('user'   => get_string('onlyuserdiary','learningdiary'),
                         'guided' => get_string('onlyguideddiary','learningdiary'));
        $mform->addElement('select', 'diarymode', get_string('diarymode','learningdiary'), $opmodes);

        $opnumberings = array(get_string('nonumbering','learningdiary'),
                              get_string('normalnumbering','learningdiary'));
        $mform->addElement('select', 'numbering', get_string('numbering','learningdiary'), $opnumberings);

        $features = new stdClass;
        $features->groups = false;
        $features->groupings = false;
        $features->groupmembersonly = false;
        $features->idnumber = false;
        $features->gradecat = false;
        $this->standard_coursemodule_elements($features);

        $this->add_action_buttons();


    }
}
?>