<?php  // $Id: management.php,v 1.4.2.1 2008/03/26 10:59:59 janne Exp $

/// This page prints a page history of learningdiary chapter.

    require_once("../../config.php");
    require_once("lib.php");

    $diary = new modLearningdiary(); // Instantiate learningdiary object.

    $skey     = required_param('sesskey', PARAM_ALPHANUM);
    $pageid   = optional_param('pageid',   0, PARAM_INT);
    $parentid = optional_param('parentid', 0, PARAM_INT);
    $action   = optional_param('action', false, PARAM_ALPHA);
    $tab      = optional_param('tab', 3, PARAM_INT);

    if ( !$diary->isteacher ) {
        error("Only teachers can view this page!",
              "$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
    }

    if ( $data = data_submitted() ) {
        if ( !confirm_sesskey($skey) ) {
            error("Session key error!!!");
        }

        if ( !empty($data->removeselected) ) {
            $USER->ldconfirmkey = random_string(5);
            if ( is_array($data->remove) ) {
                foreach ( $data->remove as $key => $value ) {
                    $data->remove[$key] = clean_param($value, PARAM_INT);
                }
            }
            $confirm['confirmkey'] = $USER->ldconfirmkey;
            $confirm['removeids']  = $data->remove;
            $confirmstr = base64_encode(serialize($confirm));
            redirect("managementconfirm.php?id={$diary->cm->id}&amp;sesskey={$USER->sesskey}&amp;confirm=$confirmstr");
            exit;
        }

        if ( empty($data->cancel) ) {
            $newrecord = new stdClass;
            $newrecord->parentid = clean_param($data->parentid, PARAM_INT);
            $newrecord->learningdiaryid = $diary->module->id;
            $newrecord->title    = addslashes(trim(strip_tags($data->title)));
            $newrecord->information = addslashes(trim(strip_tags($data->information, $ALLOWED_TAGS)));
            $newrecord->available = make_timestamp($data->pyear, $data->pmonth, $data->pday,
                                                   $data->phour, $data->pmin, 0);
            $newrecord->created   = time();
            $newrecord->format = intval($data->format);

            if ( intval($data->pageid != 0) ) {

                // Updating
                $newrecord->id = clean_param($data->pageid, PARAM_INT);
                unset($newrecord->created);
                if ( !update_record("learningdiary_guided_structure", $newrecord) ) {
                    error("Could not update record $newrecord->title",
                          "$CFG->wwwroot/mod/learningdiary/management.php?id={$diary->cm->id}".
                          "&amp;sesskey=$USER->sesskey");
                }

            } else {

                if ( !insert_record("learningdiary_guided_structure", $newrecord) ) {
                    error("Could not add new record $newrecord->title",
                          "$CFG->wwwroot/mod/learningdiary/management.php?id={$diary->cm->id}".
                          "&amp;sesskey=$USER->sesskey");
                }

            }
        }
    }

    $usehtmleditor = can_use_html_editor();

    if ( $action ) {

        if ( $action != 'edit') {
            // Adding new.
            $structure = get_record("learningdiary_guided_structure", "id", $parentid);
            if ( empty($structure) ) {
                $structure = new stdClass;
            }
            $structure->parentid = !empty($structure->id) ? $structure->id : 0;
            $structure->title = '';
            $structure->information = '';
            $structure->available = !empty($structure->available) ? $structure->available : time();
            $structure->format = ($usehtmleditor) ? FORMAT_HTML : FORMAT_MOODLE;
        } else {
            // Editing.
            $structure = get_record("learningdiary_guided_structure", "id", $pageid);
        }

    } else {

        $structure = get_records("learningdiary_guided_structure", "learningdiaryid", $diary->module->id);

    }

    // Cache some strings
    $strmanagement = get_string('management','learningdiary');
    $strcreated    = get_string('created','learningdiary');

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");
    $initeditor = false;

    $extlinks = array(array('name' => $strmanagement, 'link' => '', 'type' => $strmanagement));
    $navigation = build_navigation($extlinks, $diary->cm);

    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 $navigation, "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));

    $diary->tabs($tab);

    print_simple_box_start('center', '100%');
    include('managementform.php');
    print_simple_box_end();

    if ( $usehtmleditor && $initeditor ) {
        use_html_editor();
    }

    print_footer($diary->course);

//////////////////////////////////// HELPING FUNCTIONS ////////////////////////////////////

function learningdiary_print_structure($parent, $arrecords) {

    global $CFG;
    static $count;

    if ( empty($count) ) {
        $count = 0;
    }

    print '<ul style="list-style-type: none;">' . "\n";
    foreach ( $arrecords as $record ) {
        if ( $record->parentid == $parent ) {
            print '<li>' . learningdiary_print_entry($record) .
                  '</li>'.
                  "\n";
            $count++;
            learningdiary_print_structure($record->id, $arrecords);
        }
    }
    print "</ul>\n";
    $count--;

}

function learningdiary_print_entry($record) {
    global $diary, $USER;
    ?>
    <input type="hidden" name="pageid" value="<?php p($record->id) ?>" />
    <input type="hidden" name="parentid" value="<?php p($record->parentid) ?>" />
    <table border="0" cellpadding="4" cellspacing="2" width="100%" style="border: 1px solid #ddd;">
        <tr valign="top">
            <td align="right" width="120"><p><?php print_string('chapter','learningdiary') ?>:</p></td>
            <td><p><?php echo($record->title) ?></p></td>
        </tr>
        <tr valign="top">
            <td align="right" width="120"><p><?php print_string('question','learningdiary') ?>:</p></td>
            <td><?php
            $options = new stdClass;
            $options->noclean = true;
            print(format_text(stripslashes($record->information), FORMAT_MOODLE, $options));
            ?></td>
        </tr>
        <tr valign="top">
            <td align="right" width="120"><?php print_string('available','learningdiary') ?>:</td>
            <td><?php
            print(userdate($record->available));
            ?></td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td>[ <a href="management.php?id=<?php p($diary->cm->id) ?>&amp;sesskey=<?php
            p($USER->sesskey) ?>&amp;action=edit&amp;pageid=<?php p($record->id) ?>"><?php print_string('edit') ?></a> |
            <a href="management.php?id=<?php p($diary->cm->id) ?>&amp;sesskey=<?php
            p($USER->sesskey) ?>&amp;action=add&amp;parentid=<?php p($record->id) ?>"><?php print_string('addsubchapter','learningdiary') ?></a> ]
            </td>
        </tr>
        <tr>
            <td>&nbsp;</td>
            <td><input type="checkbox" name="remove[]" value="<?php p($record->id) ?>" /> <?php print_string('deleteentry','learningdiary') ?></td>
        </tr>
    </table>
    <?php
}
?>