<?php // $Id: userdiaryadd.php,v 1.6 2007/02/04 22:17:59 janne Exp $

    require_once("../../config.php");
    require_once("lib.php");

    $diary = new modLearningdiary();

    $skey    = required_param('sesskey', PARAM_ALPHANUM); // Session key.
    $pageid  = optional_param('pageid', 0, PARAM_INT);   // Page id if we're making sub chapter.

    if (! confirm_sesskey($skey) ) {
        error("Invalid session identifier!!!");
    }

    $usehtmleditor = can_use_html_editor();

    if ( (!$diary->isstudent) or ($diary->isteacher or $diary->isguest) ) {
        error("Only students can add entries to user diary!!!",
              "$CFG->wwwroot/course/view.php?id=$course->id");
    }

    if ( $data = data_submitted() ) {

        if ( !empty($data->cancel) ) {
            redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}");
        }

        $error = array();
        $newpage = new stdClass;
        $newpage->parentid = clean_param($data->parentid, PARAM_INT);
        $newpage->learningdiaryid = clean_param($diary->module->id, PARAM_INT);
        $newpage->userid = clean_param($USER->id, PARAM_INT);
        $newpage->title = stripslashes($data->title);
        $newpage->title = trim(htmlspecialchars(strip_tags($newpage->title), ENT_QUOTES));

        if ( empty($newpage->title) ) {
            $error['notitle'] = get_string('errornotitle','learningdiary');
        }

        $newpage->title = addslashes($newpage->title);
        $newpage->content = stripslashes($data->content);
        $newpage->content = trim(strip_tags($newpage->content, $ALLOWED_TAGS));

        if ( empty($newpage->content) ) {
            $error['nocontent'] = get_string('errornocontent','learningdiary');
        }

        $newpage->content = addslashes($newpage->content);
        $newpage->hidden  = 0;
        $newpage->created = time();
        $newpage->format = intval($data->format);

        if ( empty($error) ) {
            if ( $newpageid = insert_record("learningdiary_pages", $newpage) ) {

                $history = new stdClass;
                $history->learningdiaryid = $newpage->learningdiaryid;
                $history->pageid = clean_param($newpageid, PARAM_INT);
                $history->modified = $newpage->created;
                $history->version = '1.0';
                $history->content = $newpage->content;

                insert_record("learningdiary_page_history", $history);

                redirect("$CFG->wwwroot/mod/learningdiary/view.php?id={$diary->cm->id}&amp;" .
                         "tab=1&amp;pageid=$newpageid");
            }
        }
    }

    /// Print page.

    $navigation = '';
    if ($diary->course->category) {
        $navigation = "<a href=\"../../course/view.php?id={$diary->course->id}\">{$diary->course->shortname}</a> ->";
    }

    $strlearningdiaries = get_string("modulenameplural", "learningdiary");
    $strlearningdiary   = get_string("modulename", "learningdiary");
    $stradd             = get_string('newchapter', 'learningdiary');

    $strchaptertitle = get_string('chapter', 'learningdiary');
    $strcontent      = get_string('content',      'learningdiary');
    $strlevel        = get_string('level',        'learningdiary');

    print_header("{$diary->course->shortname}: {$diary->module->name}", "{$diary->course->fullname}",
                 "$navigation <a href=\"index.php?id={$diary->course->id}\">$strlearningdiaries</a> -> ".
                 "<a href=\"view.php?id={$diary->cm->id}\">{$diary->module->name}</a> -> $stradd",
                 "", "", true,
                 update_module_button($diary->cm->id, $diary->course->id, $strlearningdiary),
                 navmenu($diary->course, $diary->cm));

    $diary->tabs();

    print_simple_box_start('center', '100%');
    print_heading($stradd, 'center');
    ?>

    <form method="post" action="userdiaryadd.php">
    <input type="hidden" name="id"      value="<?php p($diary->cm->id); ?>" />
    <input type="hidden" name="sesskey" value="<?php p($USER->sesskey); ?>" />
    <input type="hidden" name="tab"     value="1" />
    <table border="0" cellpadding="4" align="center">
    <tr>
        <td align="right"><strong><?php echo $strlevel ?></strong>:</td>
        <td><select name="parentid"><?php $levels = $diary->_get_levels($USER->id);
        //choose_from_menu($levels, "parentid", 0, "");
        echo $levels;
        ?></select></td>
    </tr>
    <tr>
        <td align="right"><strong><?php echo $strchaptertitle ?></strong>:</td>
        <td><input type="text" name="title" size="50" value="" /><?php
        if ( !empty($error['notitle']) ) echo ' <span style="color: red;">'. $error['notitle'] .'</span>';
        ?></td>
    </tr>
    <tr>
        <td align="right" valign="top"><strong><?php echo $strcontent ?></strong>:</td>
        <td valign="top"><?php
        print_textarea($usehtmleditor, "20", "60", "", "", "content", '', $diary->course->id);
        ?><?php
        if ( !empty($error['nocontent']) ) echo ' <span style="color: red;">'. $error['nocontent'] .'</span>';
        ?><br />
        <?php
        if ($usehtmleditor) {   /// Trying this out for a while
            print_string('formathtml');
            echo '<input type="hidden" name="format" value="'.FORMAT_HTML.'" />';
        } else {
            choose_from_menu(format_text_menu(), "format", FORMAT_MOODLE, "");
        }
        helpbutton("textformat", get_string("helpformatting"));
        ?></td>
    </tr>
    <tr>
        <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
        <td><input type="submit" value="<?php print_string('savechanges'); ?>" />
        <input type="submit" name="cancel" value="<?php print_string('cancel'); ?>" /></td>
    </tr>
    </table>
    </form>
    <?php
    print_simple_box_end();

    if ( $usehtmleditor ) {
        use_html_editor();
    }

    print_footer($diary->course);
?>